

/******************************************************************************************
 *                                                                                        *
 *  Ex1.     :   Read BCD Code(4bit) From Touch PAD Key 4x4 Out To RS232                  *
 *                        (Format:Press Single Key only)                                  *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
  * Target MCU       : PIC18F8722 (ET-BASE PIC8722(ICD2))                                 *
 *                   : X-TAL : 10 MHz                                                     *
 *                   : CPU Clock = 40 MHz (x4)                                            *  
 *                                                                                        *
 * Editor-Compiler   : CCS Version 4.124                                                  *
 *                                                                                        *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                               *
 * Last Update       : 10/September/2014                                                  *
 *                                                                                        *
 * Port Interface    :  -- MCU-PIC-18F8722--                  -- Key Touch PAD 4x4 --     *
 *                                                                                        *
 *                     PJ0(Input)          Connect                 BCD Colum 1            * 
 *                     PJ1(Input)          Connect                 BCD Colum 2            *
 *                     PJ2(Input)          Connect                 BCD Colum 4            *
 *                     PJ3(Input)          Connect                 BCD Colum 8            *
 *                     PJ4(Input)          Connect                 T#/R Ststus 1Key       *
 *                     PJ5(Input)          Not Use                 SHIF# Statu 2Key       *
 *                                                                                        *
 *       UART1       :  RC6 = TX1          Connect              Tx of Board Touch Key     *
 *                      RC7 = RX1          Connect              Rx of Board Touch Key     *                                                                        *
 *                      Baud Rate = 9600  at Clock 40Mhz                                  *
 *                                                                                        *
 *    LED DISPLAY : RB[0..7]              Connect                 LED Common Anode        *
 *                                                                                        *  
 *                                                                             5V         *
 *                                                                             -+-        *
 *                                                              560      \\     |         *
 *                                                      RB0 --/\/\/\---|<|-----+          *
 *                                                                      .       |         *
 *                                                              560     . \\    |         *
 *                                                      RB7 --/\/\/\-----|<|---+          *
 *                                                                                        *
 *                                                                                        *
 *  Operation    : When Touch Key will Show Key Code on Heperterminal and LED RB[0..7]    *  
 *                                                                                        *
 ******************************************************************************************/
 

#include <18F8722.h>
#include <stdio.h>

#define TX1   PIN_C6
#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)
#use rs232(baud = 9600, xmit = TX1, rcv = RX1)   //Set Rs232

#use fast_io(ALL)                                //Stop Set direction Auto for All Port  by Compiler  


int8 Check_TR(void)     ;
int8 RD_KeyCode(void)   ;
 

//*************************** Main *************************

void main (void) 
    {                               
     unsigned int8 key ;   
     
     //------------- Initial Port -----------
      set_tris_B(0x00)                ;        //Set RB(0..7) = Output for LED Display  
      set_tris_J(0xFF)                ;        //Set RJ(0..7) = Input for Read BCD Key Code
 
                
      OUTPUT_B(0xFF)                  ;       //Set data 0xFF Default RB = LED OFF  
      
     //---------initial Uart1 ------------

      set_tris_C(0x80)                ;        //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out
    
    //---------------- Main -----------------
    
    printf("*************************************************************************\r\n");    
    printf("**          Ex1.TEST READ KEY CODE BCD Touch PAD4x4                    **\r\n");        
    printf("*************************************************************************\r\n"); 
  
    while(true)
     {
       if(!Check_TR())                             //Step1: Check  pressed key (Check_TR()=0:press,1:release) 
        {
         key = RD_KeyCode()                     ;  //Step2: Read Key Code

         //---------- Step3:Program Respond press key for user ------------
       
          OUTPUT_B(~key)                        ;   //Out Hex data key Code to LED P0[0..7]
          printf("Key_Code BCD = 0x%X",key)    ;   //Print Key Code Out RS232
          printf("\n\r")                        ;

          while(!Check_TR()){;}                 ; //Wait Release Key (=1 exit loop)
        }          
     }   //while
   }

//********************** Sub Program *************************

//---------------------- Check Touch /Release Key -------------------

int8 Check_TR(void)    
 {
   int8 tr   ;
        
      tr  = INPUT_J()             ;   //Read Status Key
      tr  = tr & 0x10             ;   //Mark bit PJ4 (Statust Press or Release)
   
    if(tr != 0x10)                    //Check Statue Key
      return (0)                 ;    //Touch Key Return 0 (PJ4=0)
    else
       return (1)                ;    //Release Key Return 1   (PJ4=1)
 }


//---------- Read BCD Key Code -----------------

 int8 RD_KeyCode(void) 
  {
    unsigned int8 KeyCode                  ;
  
    KeyCode      = INPUT_J()               ;   //Read Key Code
    KeyCode      = KeyCode & 0x0F          ;   //Mark bit PJ0-PJ3(Key Code 4 bit)
    return (KeyCode)                       ;
  }



